--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNpathObjectList ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobjectSwitch
  local LOChandlesArray = #()
  local LOCnamesArray = #()
  local LOCnodesArray = #()
  local LOCpopupMenu
  local LOCuiResourcesObjClasses = #()

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNobjListPopupMenu =
  (
    DYNpathObjectList.LOCpopupMenu = undefined
    if DYNpathObjectList.LIDYNobjectList.selection != undefined then
    (
      local LOCexe = "rcmenu LOCpopupMenu\n"
      LOCexe += "(\n"
      LOCexe += "  local LOCselNode\n"
      LOCexe += "  local LOCselHandle\n"
      LOCexe += "  local LOCobjectSwitch = DYNpathObjectList.LOCobjectSwitch\n"
      LOCexe += "\n"
      LOCexe += "  --- Define Menu Functions\n"
      LOCexe += "  fn DYNFUNvehicleSelected     = (LOCobjectSwitch  == 1)\n"
      LOCexe += "  fn DYNFUNcat2to6Selected     = (LOCobjectSwitch  >= 2 and LOCobjectSwitch <= 6)\n" -- Clone should not be available for vehicles (breaks with new wheel rotation functionality)
      LOCexe += "  fn DYNFUNcat1to6Selected     = (LOCobjectSwitch  >= 1 and LOCobjectSwitch <= 6)\n"
      LOCexe += "  fn DYNFUNshapeSelected       = (LOCobjectSwitch  == 7 or LOCobjectSwitch == 17) and classOf LOCselNode != NURBSCurveShape\n"
      LOCexe += "  fn DYNFUNcameraSelected      = (LOCobjectSwitch  == 5 or LOCobjectSwitch == 19)\n"
      LOCexe += "  fn DYNFUNsosSelected         = (LOCobjectSwitch  == 9)\n"
      LOCexe += "  fn DYNFUNforestPluginAvail   = ((DYNpluginStatus == 2) and (LOCobjectSwitch == 7 or LOCobjectSwitch == 17))\n"
      LOCexe += "  fn DYNFUNimportedObjSelected = (LOCobjectSwitch  == 7 or LOCobjectSwitch == 8)\n"
      LOCexe += "\n"
      LOCexe += "  --- Define menu layout\n"
      LOCexe += "  menuItem  MNDYNproperties     checked:false\n"
      LOCexe += "  menuItem  MNDYNimpObjMan      checked:false filter:DYNFUNimportedObjSelected\n"
      LOCexe += "  separator MNDYNseparator00\n"
      LOCexe += "  menuItem  MNDYNrename         checked:false\n"
      LOCexe += "  menuItem  MNDYNclone          checked:false filter:DYNFUNcat2to6Selected\n"
      LOCexe += "  menuItem  MNDYNdelSelected    checked:false\n"
      LOCexe += "  separator MNDYNseparator01A\n"
      LOCexe += "  menuItem  MNDYNrevertToPRS    checked:false filter:DYNFUNcat1to6Selected\n"
      LOCexe += "  separator MNDYNseparator01B                 filter:DYNFUNcat1to6Selected\n"
      LOCexe += "  menuItem  MNDYNreportShape    checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "  separator MNDYNseparator02B                 filter:DYNFUNshapeSelected\n"
      LOCexe += "\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[7] + "\" filter:DYNFUNshapeSelected\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNrmsCreate2   checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "    menuItem  MNDYNrmsCreate3   checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "    menuItem  MNDYNrosCreate2   checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "    menuItem  MNDYNsosCreate2   checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "    menuItem  MNDYNbosCreate2   checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "    menuItem  MNDYNforCreate    checked:false filter:DYNFUNforestPluginAvail\n"
      LOCexe += "    menuItem  MNDYNtriCreate    checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  separator MNDYNseparator02A                 filter:DYNFUNshapeSelected\n"
      LOCexe += "  menuItem  MNDYNopsCreate      checked:false filter:DYNFUNshapeSelected\n"
      LOCexe += "\n"
      LOCexe += "  separator MNDYNseparator03                  filter:DYNFUNshapeSelected\n"
      LOCexe += "  menuItem  MNDYNcameraLook     checked:false filter:DYNFUNcameraSelected\n"
      LOCexe += "  separator MNDYNseparator04                  filter:DYNFUNcameraSelected\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[6] + "\" filter:DYNFUNvehicleSelected\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNbody1 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody2 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody3 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody4 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody5 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody6 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody7 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody8 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "    menuItem  MNDYNbody9 \"\"     checked:false filter:DYNFUNvehicleSelected\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  menuItem  MNDYNsosSelected    checked:false filter:DYNFUNsosSelected\n"
      LOCexe += "  separator MNDYNseparator04a                 filter:DYNFUNsosSelected\n"
      LOCexe += "\n"
      LOCexe += "  menuItem  MNDYNhideSelected   checked:false\n"
      LOCexe += "  menuItem  MNDYNfreezeSelected checked:false\n"
      LOCexe += "  separator MNDYNseparator05\n"
      LOCexe += "  menuItem  MNDYNzoomSelected   checked:false\n"
      LOCexe += "  separator MNDYNseparator06\n"
      LOCexe += "  menuItem  MNDYNrefresh        checked:false\n"
      LOCexe += "  separator MNDYNseparator07\n"
      LOCexe += "  menuItem  MNDYNhelp           checked:false\n"
      LOCexe += "  menuItem  MNDYNtutorials      checked:false\n"
      LOCexe += "\n"
      LOCexe += "  on LOCpopupMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNproperties.text     = DYNuiResourcesMenus[8]\n"
      LOCexe += "    MNDYNrename.text         = DYNuiResourcesMenus[7]\n"
      LOCexe += "    MNDYNclone.text          = DYNuiResourcesMenus[9]\n"
      LOCexe += "    MNDYNdelSelected.text    = DYNuiResourcesMenus[10]\n"
      LOCexe += "    MNDYNimpObjMan.text      = DYNuiResourcesMenus[50]\n"
      LOCexe += "    MNDYNrevertToPRS.text    = DYNuiResourcesMenus[51]\n"
      LOCexe += "    MNDYNreportShape.text    = DYNuiResourcesMenus[52]\n"
      LOCexe += "    MNDYNrmsCreate2.text     = DYNuiResourcesMenus[53]\n"
      LOCexe += "    MNDYNrmsCreate3.text     = DYNuiResourcesMenus[54]\n"
      LOCexe += "    MNDYNrosCreate2.text     = DYNuiResourcesMenus[55]\n"
      LOCexe += "    MNDYNsosCreate2.text     = DYNuiResourcesMenus[56]\n"
      LOCexe += "    MNDYNbosCreate2.text     = DYNuiResourcesMenus[57]\n"
      LOCexe += "    MNDYNforCreate.text      = DYNuiResourcesMenus[58]\n"
      LOCexe += "    MNDYNtriCreate.text      = DYNuiResourcesMenus[59]\n"
      LOCexe += "    MNDYNopsCreate.text      = DYNuiResourcesMenus[60]\n"
      LOCexe += "    MNDYNcameraLook.text     = DYNuiResourcesMenus[61]\n"
      LOCexe += "    MNDYNsosSelected.text    = DYNuiResourcesMenus[62]\n"
      LOCexe += "    MNDYNhideSelected.text   = DYNuiResourcesMenus[63]\n"
      LOCexe += "    MNDYNfreezeSelected.text = DYNuiResourcesMenus[64]\n"
      LOCexe += "    MNDYNzoomSelected.text   = DYNuiResourcesMenus[11]\n"
      LOCexe += "    MNDYNrefresh.text        = DYNuiResourcesMenus[2]\n"
      LOCexe += "    MNDYNhelp.text           = DYNuiResourcesMenus[5]\n"
      LOCexe += "    MNDYNtutorials.text      = DYNuiResourcesMenus[6]\n"
      LOCexe += "\n"
      LOCexe += "    LOCselHandle = DYNpathObjectList.LOChandlesArray[DYNpathObjectList.LIDYNobjectList.selection]\n"
      LOCexe += "    LOCselNode   = try (maxOps.getNodeByHandle LOCselHandle) catch ()\n"
      LOCexe += "    if DYNpathObjectList.LOCobjectSwitch > 13 then MNDYNproperties.enabled = false else MNDYNproperties.enabled = true\n"
      LOCexe += "    if LOCselNode == undefined then\n"
      LOCexe += "    (\n"
      LOCexe += "      MNDYNhideSelected.enabled   = false\n"
      LOCexe += "      MNDYNfreezeSelected.enabled = false\n"
      LOCexe += "      MNDYNzoomSelected.enabled   = false\n"
      LOCexe += "      MNDYNdelSelected.enabled    = false\n"
      LOCexe += "      MNDYNreportShape.enabled    = false\n"
      LOCexe += "      MNDYNopsCreate.enabled      = false\n"
      LOCexe += "      MNDYNrmsCreate2.enabled     = false\n"
      LOCexe += "      MNDYNrmsCreate3.enabled     = false\n"
      LOCexe += "      MNDYNtriCreate.enabled      = false\n"
      LOCexe += "      MNDYNsosCreate2.enabled     = false\n"
      LOCexe += "      MNDYNrosCreate2.enabled     = false\n"
      LOCexe += "      MNDYNbosCreate2.enabled     = false\n"
      LOCexe += "      MNDYNforCreate.enabled      = false\n"
      LOCexe += "    )\n"
      LOCexe += "    else\n"
      LOCexe += "    (\n"
      LOCexe += "      MNDYNbosCreate2.enabled  = true\n"
      LOCexe += "      MNDYNrmsCreate3.enabled  = true\n"
      LOCexe += "      MNDYNtriCreate.enabled   = true\n"
      LOCexe += "      MNDYNforCreate.enabled   = true\n"
      LOCexe += "\n"
      LOCexe += "      MNDYNhideSelected.checked   = LOCselNode.isHidden\n"
      LOCexe += "      MNDYNfreezeSelected.checked = LOCselNode.isFrozen\n"
      LOCexe += "      MNDYNcameraLook.checked     = if viewPort.getCamera() == LOCselNode then true else false\n"
      LOCexe += "\n"
      LOCexe += "      MNDYNdelSelected.enabled = if classOf LOCselNode == PolymorphicGeomshape or classOf LOCselNode.baseObject == LinkLeafshape or classOf LOCselNode == LinkComposite or classOf LOCselNode == PolymorphicGeom then false else true\n"
      LOCexe += "\n"
      LOCexe += "      if DYNFUNvehicleSelected() then\n"
      LOCexe += "      (\n"
      LOCexe += "        if striCmp (subString LOCselNode.material.name 1 DYNmatNameVehicles.count) DYNmatNameVehicles == 0 then\n"
      LOCexe += "        (\n"
      LOCexe += "          MNDYNbody1.enabled = true\n"
      LOCexe += "          MNDYNbody2.enabled = true\n"
      LOCexe += "          MNDYNbody3.enabled = true\n"
      LOCexe += "          MNDYNbody4.enabled = true\n"
      LOCexe += "          MNDYNbody5.enabled = true\n"
      LOCexe += "          MNDYNbody6.enabled = true\n"
      LOCexe += "          MNDYNbody7.enabled = true\n"
      LOCexe += "          MNDYNbody8.enabled = true\n"
      LOCexe += "          MNDYNbody9.enabled = true\n"
      LOCexe += "          local LOCmatNameArray = DYNFUNgetmatchannelnames LOCselNode.material true false DYNINImatIDlimit\n"
      LOCexe += "          if LOCmatNameArray.count >= 9 then\n"
      LOCexe += "          (\n"
      LOCexe += "            local LOCexistColour = (getAppData LOCselNode 423) as integer\n"
      LOCexe += "            MNDYNbody1.text = LOCmatNameArray[1]; if LOCexistColour == 1 then MNDYNbody1.checked = true else MNDYNbody1.checked = false\n"
      LOCexe += "            MNDYNbody2.text = LOCmatNameArray[2]; if LOCexistColour == 2 then MNDYNbody2.checked = true else MNDYNbody2.checked = false\n"
      LOCexe += "            MNDYNbody3.text = LOCmatNameArray[3]; if LOCexistColour == 3 then MNDYNbody3.checked = true else MNDYNbody3.checked = false\n"
      LOCexe += "            MNDYNbody4.text = LOCmatNameArray[4]; if LOCexistColour == 4 then MNDYNbody4.checked = true else MNDYNbody4.checked = false\n"
      LOCexe += "            MNDYNbody5.text = LOCmatNameArray[5]; if LOCexistColour == 5 then MNDYNbody5.checked = true else MNDYNbody5.checked = false\n"
      LOCexe += "            MNDYNbody6.text = LOCmatNameArray[6]; if LOCexistColour == 6 then MNDYNbody6.checked = true else MNDYNbody6.checked = false\n"
      LOCexe += "            MNDYNbody7.text = LOCmatNameArray[7]; if LOCexistColour == 7 then MNDYNbody7.checked = true else MNDYNbody7.checked = false\n"
      LOCexe += "            MNDYNbody8.text = LOCmatNameArray[8]; if LOCexistColour == 8 then MNDYNbody8.checked = true else MNDYNbody8.checked = false\n"
      LOCexe += "            MNDYNbody9.text = LOCmatNameArray[9]; if LOCexistColour == 9 then MNDYNbody9.checked = true else MNDYNbody9.checked = false\n"
      LOCexe += "          )\n"
      LOCexe += "        )\n"
      LOCexe += "        else\n"
      LOCexe += "        (\n"
      LOCexe += "          MNDYNbody1.enabled = false\n"
      LOCexe += "          MNDYNbody2.enabled = false\n"
      LOCexe += "          MNDYNbody3.enabled = false\n"
      LOCexe += "          MNDYNbody4.enabled = false\n"
      LOCexe += "          MNDYNbody5.enabled = false\n"
      LOCexe += "          MNDYNbody6.enabled = false\n"
      LOCexe += "          MNDYNbody7.enabled = false\n"
      LOCexe += "          MNDYNbody8.enabled = false\n"
      LOCexe += "          MNDYNbody9.enabled = false\n"
      LOCexe += "        )\n"
      LOCexe += "      )\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    if classOf LOCselNode == SplineShape or classOf LOCselNode == line then\n"
      LOCexe += "    (\n"
      LOCexe += "      MNDYNbosCreate2.enabled  = DYNFUNclosedShapeFilter LOCselNode\n"
      LOCexe += "      MNDYNrmsCreate3.enabled  = DYNFUNclosedShapeFilter LOCselNode\n"
      LOCexe += "      MNDYNtriCreate.enabled   = DYNFUNclosedShapeFilter LOCselNode\n"
      LOCexe += "      MNDYNforCreate.enabled   = if DYNFUNforestPluginAvail() then DYNFUNclosedShapeFilter LOCselNode else false\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    if classOf LOCselNode == arc then\n"
      LOCexe += "    (\n"
      LOCexe += "      MNDYNbosCreate2.enabled  = false\n"
      LOCexe += "      MNDYNrmsCreate3.enabled  = false\n"
      LOCexe += "      MNDYNtriCreate.enabled   = false\n"
      LOCexe += "      MNDYNforCreate.enabled   = false\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    MNDYNreportShape.enabled = if classOf LOCselNode == SplineShape then true else false\n"
      LOCexe += "\n"
      LOCexe += "    if DYNFUNcat1to6Selected() then\n"
      LOCexe += "    (\n"
      LOCexe += "      --- Does this object have a DYNXFCC/DYNXFCCV3/DYNXFCCM3 Position Controller?\n"
      LOCexe += "      local LOCobjectController = try (LOCselNode.transform.controller) catch ()\n"
      LOCexe += "      if classOf LOCobjectController == DynXFCC or classOf LOCobjectController == DynXFCCM3 or classOf LOCobjectController == DynXFCCV3 then\n"
      LOCexe += "      (\n"
      LOCexe += "        MNDYNrevertToPRS.enabled = MNDYNclone.enabled = if isValidNode LOCobjectController.path then true else false\n"
      LOCexe += "      )\n"
      LOCexe += "      else\n"
      LOCexe += "      (\n"
      LOCexe += "        --- If not, is this object attached to another object which has a DYNXFCC/DYNXFCCV3/DYNXFCCM3 position controller applied to it?\n"
      LOCexe += "        if isValidNode LOCselNode.parent then\n"
      LOCexe += "        (\n"
      LOCexe += "          local LOCposStatus = try (classOf LOCselNode.parent.transform.controller) catch ()\n"
      LOCexe += "          MNDYNrevertToPRS.enabled = MNDYNclone.enabled = if LOCposStatus == DynXFCC or LOCposStatus == DynXFCCM3 or LOCposStatus == DynXFCCV3 then true else false\n"
      LOCexe += "        )\n"
      LOCexe += "        else\n"
      LOCexe += "        (\n"
      LOCexe += "          MNDYNrevertToPRS.enabled = false\n"
      LOCexe += "        )\n"
      LOCexe += "      )\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNbody1 picked do DYNFUNchangeVehicleBody LOCselNode 1\n"
      LOCexe += "  on MNDYNbody2 picked do DYNFUNchangeVehicleBody LOCselNode 2\n"
      LOCexe += "  on MNDYNbody3 picked do DYNFUNchangeVehicleBody LOCselNode 3\n"
      LOCexe += "  on MNDYNbody4 picked do DYNFUNchangeVehicleBody LOCselNode 4\n"
      LOCexe += "  on MNDYNbody5 picked do DYNFUNchangeVehicleBody LOCselNode 5\n"
      LOCexe += "  on MNDYNbody6 picked do DYNFUNchangeVehicleBody LOCselNode 6\n"
      LOCexe += "  on MNDYNbody7 picked do DYNFUNchangeVehicleBody LOCselNode 7\n"
      LOCexe += "  on MNDYNbody8 picked do DYNFUNchangeVehicleBody LOCselNode 8\n"
      LOCexe += "  on MNDYNbody9 picked do DYNFUNchangeVehicleBody LOCselNode 9\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNcameraLook     picked do (viewPort.setCamera LOCselNode)\n"
      LOCexe += "  on MNDYNproperties     picked do (macros.run \"Civil View\" \"MCRproperties\")\n"
      LOCexe += "  on MNDYNreportShape    picked do (DYNFUNmakeShapeReport LOCselNode)\n"
      LOCexe += "  on MNDYNopsCreate      picked do (macros.run \"Civil View\" \"MCRobjectPlacer\")\n"
      LOCexe += "  on MNDYNrosCreate2     picked do (local LOCrailArray  = DYNFUNcreateRails #(LOCselNode) \"\" (DYNFUNgetLocalTime()) (not DYNINIallowMultRails) sceneMaterials #() undefined false; DYNFUNnodeCreatedCallback(); if LOCrailArray.count > 0 then select LOCrailArray[1])\n"
      LOCexe += "  on MNDYNbosCreate2     picked do (local LOCbuildArray = DYNFUNcreateBuild #(LOCselNode) \"\" (DYNFUNgetLocalTime()) sceneMaterials 2.5 1 2 10.0 1 true undefined undefined false; DYNFUNnodeCreatedCallback(); if LOCbuildArray.count > 0 then select LOCbuildArray[1])\n"
      LOCexe += "  on MNDYNrmsCreate2     picked do (local LOCmarkArray  = DYNFUNcreateMarks #(LOCselNode) \"\" rootNode.DYNrootNodeStore.markVshift rootNode.DYNrootNodeStore.markFreeze (DYNFUNgetLocalTime()) DYNINImarkingColor [10.0,0.0,0.2] false (not DYNINIallowMultMarks) sceneMaterials undefined false 0.0 0.0 0.0; DYNFUNnodeCreatedCallback(); if LOCmarkArray.count > 0 then select LOCmarkArray[1])\n"
      LOCexe += "  on MNDYNrmsCreate3     picked do (local LOCmarkArray  = DYNFUNcreateChevrons #(LOCselNode) \"\" rootNode.DYNrootNodeStore.markVshift rootNode.DYNrootNodeStore.markFreeze (DYNFUNgetLocalTime()) DYNINImarkingColor [2.0,2.0,2.0] false true sceneMaterials undefined false 60; DYNFUNnodeCreatedCallback(); if LOCmarkArray.count > 0 then select LOCmarkArray[1])\n"
      LOCexe += "  on MNDYNimpObjMan      picked do (macros.run \"Civil View\" \"MCRimportMan\"; if DYNimportMan.dnLv.selectedItems.count > 0 then (DYNimportMan.dnLv.selectedItems.item[0].ensureVisible()))\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNtriCreate      picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCsurfacesMaterial = (if sceneMaterials[DYNmatNameSurfaces] != undefined then sceneMaterials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + DYNfolderSeperator)))\n"
      LOCexe += "    local LOCtri        = DYNFUNtriangulateClosedSpline LOCselNode LOCsurfacesMaterial 31\n"
      LOCexe += "    DYNFUNnodeCreatedCallback()\n"
      LOCexe += "    if isValidNode LOCtri then select LOCtri else clearSelection()\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNsosCreate2     picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    --- Decide whether to use separated or spanning spline geometry\n"
      LOCexe += "    local LOCsplineMode = -1\n"
      LOCexe += "    if try (LOCselNode.numSplines > 1) catch (false) then\n"
      LOCexe += "    (\n"
      LOCexe += "      local LOCmessage = DYNuiResourcesQueries[29]\n"
      LOCexe += "      LOCmessage += \"\n\n\"\n"
      LOCexe += "      LOCmessage += DYNuiResourcesErrorsWarnings[45]\n"
      LOCexe += "      LOCmessage += \"\n\n\"\n"
      LOCexe += "      LOCmessage += DYNuiResourcesErrorsWarnings[46]\n"
      LOCexe += "      if (querybox LOCmessage title:DYNuiResourcesTitlebars[3]) then (LOCsplineMode = 0)\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    --- Create Civil_View_Swept_Object Modifier\n"
      LOCexe += "    local LOCobjMod1 = Civil_View_Swept_Object ui:On total:1\n"
      LOCexe += "    local LOCobjMod2 = Civil_View_Divide_Spline ui:On\n"
      LOCexe += "\n"
      LOCexe += "    --- Set Up Default Parameters for Civil_View_Swept_Object\n"
      LOCexe += "    DYNsweptObjects.DYNFUNmodifySweptObject LOCobjMod1 #(0,false,DYNsosVtileDefault,0.0,LOCsplineMode,DYNsosUtileDefault,0,0,0,25,0.0) #(#()) undefined \"\"\n"
      LOCexe += "    DYNFUNmodifyDivider LOCobjMod2 LOCobjMod1.spacing LOCobjMod1.normalize\n"
      LOCexe += "\n"
      LOCexe += "    --- Set Up Parameters For First Element In Style (first element MUST be created in order to make SOS object visible\n"
      LOCexe += "    LOCobjMod1.pvre1 = DYNsweptObjects.LOCdefElemField01 -- 1: U Map Repeat\n"
      LOCexe += "    LOCobjMod1.pure1 = DYNsweptObjects.LOCdefElemField02 -- 2: V Map Repeat\n"
      LOCexe += "    LOCobjMod1.prot1 = DYNsweptObjects.LOCdefElemField03 -- 2: UV Map Rotation\n"
      LOCexe += "    LOCobjMod1.phos1 = DYNsweptObjects.LOCdefElemField04 -- 4: Horiz Off Start\n"
      LOCexe += "    LOCobjMod1.phoe1 = DYNsweptObjects.LOCdefElemField05 -- 5: Horiz Off End\n"
      LOCexe += "    LOCobjMod1.psmg1 = DYNsweptObjects.LOCdefElemField06 -- 6: Smoothing Group\n"
      LOCexe += "    LOCobjMod1.pvos1 = DYNsweptObjects.LOCdefElemField07 -- 7: Vert Off Start\n"
      LOCexe += "    LOCobjMod1.pvoe1 = DYNsweptObjects.LOCdefElemField08 -- 8: Vert Off End\n"
      LOCexe += "    LOCobjMod1.pinm1 = false                             -- 9: Inherited Mapping (not allowed on first element in style)\n"
      LOCexe += "    LOCobjMod1.pmid1 = DYNsweptObjects.LOCdefElemField10 -- 10: Material ID\n"
      LOCexe += "\n"
      LOCexe += "    --- Create Civil_View_Swept_Object Modifier and apply to selected object\n"
      LOCexe += "    local LOCsosArray  = DYNsweptObjects.DYNFUNcreateSweptObjects #(LOCselNode) \"\" LOCobjMod1 LOCobjMod2 DYNmatNameSurfaces false\n"
      LOCexe += "\n"
      LOCexe += "    --- Select New Object\n"
      LOCexe += "    DYNFUNnodeCreatedCallback()\n"
      LOCexe += "    if LOCsosArray.count > 0 then select LOCsosArray[1]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNforCreate      picked do (DYNFUNmakeForest())\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNsosSelected    picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    if (querybox (DYNuiResourcesQueries[28]) title:DYNuiResourcesTitlebars[2]) then\n"
      LOCexe += "    (\n"
      LOCexe += "      DYNamite.DYNFUNbakeGeomArray2Meshes #(LOCselNode) LOCobjectSwitch\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  --- The following try/catches are needed because object may not exist if in middle of creating objects from 3dsmax panel\n"
      LOCexe += "  on MNDYNhideSelected   picked do (try (LOCselNode.isHidden = not MNDYNhideSelected.checked) catch ())\n"
      LOCexe += "  on MNDYNfreezeSelected picked do (try (LOCselNode.isFrozen = not MNDYNfreezeSelected.checked) catch ())\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNzoomSelected   picked do (max zoomext sel)\n"
      LOCexe += "  on MNDYNhelp           picked do (DYNFUNopenHelp 13221)\n" -- id_cv_explorer
      LOCexe += "  on MNDYNtutorials      picked do (DYNFUNopenTutorials 13223)\n"
      LOCexe += "  on MNDYNrefresh        picked do (DYNpathObjectList.DYNFUNgetPathObjectList())\n"
      LOCexe += "  on MNDYNdelSelected    picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    if (querybox DYNuiResourcesQueries[1] title:DYNuiResourcesTitlebars[2]) then\n"
      LOCexe += "    (\n"
      LOCexe += "      if isValidNode LOCselNode then (with undo on ((if isOpenGroupHead LOCselNode then setGroupOpen LOCselNode false; delete LOCselNode.children; delete LOCselNode)))\n"
      LOCexe += "      DYNFUNnodeCreatedCallback()\n"
      LOCexe += "      if DYNobjHandles[LOCobjectSwitch].count > 0 then (select (maxOps.getNodeByHandle DYNobjHandles[LOCobjectSwitch][1]))\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNrename picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    local LOCnewName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[14] DYNuiResourcesLabels[107] LOCselNode.name\n"
      LOCexe += "    if LOCnewName != undefined and LOCnewName != \"\" then\n"
      LOCexe += "    (\n"
      LOCexe += "      LOCselNode.name = LOCnewName\n"
      LOCexe += "      select LOCselNode\n"
      LOCexe += "    )\n"
      LOCexe += "    --- Also rename target object\n"
      LOCexe += "    if (try (LOCselNode.target) catch ()) != undefined then\n"
      LOCexe += "    (\n"
      LOCexe += "      LOCselNode.target.name = LOCnewName + DYNuiResourcesNodeNames[2]\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "  on MNDYNclone picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    --- Does this object have a DYNXFCC/DYNXFCCV3/DYNXFCCM3 Position Controller?\n"
      LOCexe += "    local LOCobjectController = try (LOCselNode.transform.controller) catch ()\n"
      LOCexe += "    if classOf LOCobjectController == DynXFCC or classOf LOCobjectController == DynXFCCM3 or classOf LOCobjectController == DynXFCCV3 then\n"
      LOCexe += "    (\n"
      LOCexe += "      DYNFUNcloneObjectPanel LOCselNode true DYNpathObjectList.LOCobjectSwitch\n"
      LOCexe += "    )\n"
      LOCexe += "    else\n"
      LOCexe += "    (\n"
      LOCexe += "      --- If not, is this object attached to another object which has a DYNXFCC/DYNXFCCV3/DYNXFCCM3 position controller applied to it?\n"
      LOCexe += "      if isValidNode LOCselNode.parent then\n"
      LOCexe += "      (\n"
      LOCexe += "        local LOCposStatus = try (classOf LOCselNode.parent.transform.controller) catch ()\n"
      LOCexe += "        if LOCposStatus == DynXFCC or LOCposStatus == DynXFCCM3 or LOCposStatus == DynXFCCV3 then DYNFUNcloneAttachedObjectPanel LOCselNode DYNpathObjectList.LOCobjectSwitch\n"
      LOCexe += "      )\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNrevertToPRS picked do\n"
      LOCexe += "  (\n"
      LOCexe += "    --- Does this object have a DYNXFCC/DYNXFCCV3/DYNXFCCM3 Position Controller?\n"
      LOCexe += "    local LOCobjectController = try (LOCselNode.transform.controller) catch ()\n"
      LOCexe += "    if classOf LOCobjectController == DynXFCC or classOf LOCobjectController == DynXFCCM3 or classOf LOCobjectController == DynXFCCV3 then\n"
      LOCexe += "    (\n"
      LOCexe += "      if (queryBox (DYNuiResourcesQueries[27]) title:DYNuiResourcesTitlebars[2]) then\n"
      LOCexe += "      (\n"
      LOCexe += "        DYNamite.DYNFUNbakeArrayXFCCtoPRS #(LOCselNode)\n"
      LOCexe += "      )\n"
      LOCexe += "    )\n"
      LOCexe += "    else\n"
      LOCexe += "    (\n"
      LOCexe += "      --- If not, is this object attached to another object which has a DYNXFCC/DYNXFCCV3/DYNXFCCM3 position controller applied to it?\n"
      LOCexe += "      if isValidNode LOCselNode.parent then\n"
      LOCexe += "      (\n"
      LOCexe += "        local LOCposStatus = try (classOf LOCselNode.parent.transform.controller) catch ()\n"
      LOCexe += "        if LOCposStatus == DynXFCC or LOCposStatus == DynXFCCM3 or LOCposStatus == DynXFCCV3 then\n"
      LOCexe += "        (\n"
      LOCexe += "          if (queryBox (DYNuiResourcesQueries[27]) title:DYNuiResourcesTitlebars[2]) then\n"
      LOCexe += "          (\n"
      LOCexe += "            DYNamite.DYNFUNbakeArrayXFCCtoPRS #(LOCselNode)\n"
      LOCexe += "          )\n"
      LOCexe += "        )\n"
      LOCexe += "      )\n"
      LOCexe += "    )\n"
      LOCexe += "    DYNFUNnodeCreatedCallback()\n"
      LOCexe += "    select LOCselNode\n"
      LOCexe += "  )\n"
      LOCexe += ")\n"

      DYNpathObjectList.LOCpopupMenu = Execute LOCexe

      registerRightClickMenu DYNpathObjectList.LOCpopupMenu
    )
  )


  fn DYNFUNgetPathObjectList =
  (
    --- Gather Objects From Current DVSP Object Category
    DYNpathObjectList.LOChandlesArray = (DYNFUNgetCivilViewCategorizedNodeArrays "handles" false)[LOCobjectSwitch]
    DYNpathObjectList.LOCnamesArray   = (DYNFUNgetCivilViewCategorizedNodeArrays "names" false)[LOCobjectSwitch]
    DYNpathObjectList.LOCnodesArray   = (DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false)[LOCobjectSwitch]

    --- Update Panel Label
    DYNpathObjectList.LIDYNobjectList.caption = DYNpathObjectList.LOCuiResourcesObjClasses[LOCobjectSwitch] + " (" + (DYNpathObjectList.LOChandlesArray.count as string) + ")"

    --- Fill Panel with Object List
    if DYNpathObjectList.open == true then
    (
      DYNpathObjectList.LIDYNobjectList.items = DYNpathObjectList.LOCnamesArray

      --- Ensure that Selected Object is Selected in the Panel, and list is scrolled up so that selected Item is visible
      if $ != undefined then
      (
        DYNpathObjectList.LIDYNobjectList.selection = findItem DYNpathObjectList.LOCnodesArray $
        DYNpathObjectList.CPDYNwirecolor.color      = $.wireColor
      )
      else
      (
        if LOCnodesArray.count > 0 then
        (
          DYNpathObjectList.LIDYNobjectList.selection = 1
          DYNpathObjectList.CPDYNwirecolor.color      = DYNpathObjectList.LOCnodesArray[1].wireColor
        )
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  listBox LIDYNobjectList "1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9" height:4 width:(DYNiniExplorerWidth - 22) align:#center
  label LBDYNctrl align:#center
  colorPicker CPDYNwirecolor height:11 width:15 pos:[(DYNiniExplorerWidth - 35),9]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNpathObjectList open do
  (
    DYNpathObjectList.title = DYNuiRolloutNames[37]
    LOCuiResourcesObjClasses     = deepCopy DYNuiResourcesObjClasses
    LOCuiResourcesObjClasses[15] = DYNuiResourcesLabels[614]
    LBDYNctrl.text          = DYNuiResourcesLabels[353]
    LOCobjectSwitch         = DYNobjectSwitch
    DYNFUNgetPathObjectList()
  )

  on DYNpathObjectList close do
  (
    LOChandlesArray = #()
  )

  on LIDYNobjectList selected arg do
  (
    if keyboard.controlPressed then
    (
      DYNFUNobjListPopupMenu()
      if DYNpathObjectList.LOCpopupMenu != undefined then popupMenu DYNpathObjectList.LOCpopupMenu
    )
    else
    (
      DYNremovePOLrefreshEnable = false
        select LOCnodesArray[arg]
        CPDYNwirecolor.color      = try (LOCnodesArray[arg].wireColor) catch ()
      DYNremovePOLrefreshEnable = true
    )
  )

  on LIDYNobjectList rightClick arg do
  (
    DYNFUNobjListPopupMenu()
    if DYNpathObjectList.LOCpopupMenu != undefined then popupMenu DYNpathObjectList.LOCpopupMenu
  )

  on CPDYNwirecolor changed arg do
  (
    if $ != undefined then
    (
      $.wirecolor = arg
      if DYNproperties.open then DYNproperties.CPDYNobjectColor.color = arg
    )
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAuLGfMp+MwjJORI8+OyhBX+yC1XSQaPn+Z
-- lInpxIUVl/mp55P+bcS2fO4rgf6T3JGMXsXZr/ZvdhnXvG9Lj8/wxl26OQ0rkOAe
-- RGfcI3Q7M1ZHjZaHC9gTdsEsXDvVKrn9d6Z0f5Ym7JVHx9OR6ovzSYuvz7Wg1nEp
-- eYNKjDYft3SR5lmtDnyNkXvrwDGB3/pEFl3DPxjLIpovEMC2VwRFE7T9O5tuCBQW
-- NrCMhqj8kI5MzlsOkz2RFdEU5PFMnu6O9AhpIMj2uyRBWG7mOZfj2+TPFp4x9h7R
-- m27FwIMlaAzMKs4XTIsGfjDoxUK8ZAZHEvhlncnf5IBr19TM83/m
-- -----END-SIGNATURE-----